<style>
.gallery-thumb {
  width: 75% !important;
  height: 220px !important; 
  object-fit: cover !important;
  object-position: center !important;
}

</style>

<?php 
use App\Models\Konfigurasi_model;
use App\Libraries\Website;

$this->website = new Website(); 

// Ambil konfigurasi
$m_site       = new Konfigurasi_model();
$site_setting = $m_site->listing();

// Persiapan nomor & pesan WhatsApp
$whatsapp  = isset($site_setting->whatsapp) ? $site_setting->whatsapp : '';
$wa_number = preg_replace('/[^0-9]/','', $whatsapp);

$wa_msg    = isset($site_setting->pesan_whatsapp)    ? $site_setting->pesan_whatsapp    : '';
$wa_msgra  = isset($site_setting->pesan_kbradaftar)  ? $site_setting->pesan_kbradaftar  : '';
$wa_msgmi  = isset($site_setting->pesan_midaftar)    ? $site_setting->pesan_midaftar    : '';

?>

<?php if ($jenjang_pendidikan) { ?>
<section class="wrapper bg-light">
  <div class="container pt-3 pt-md-6">
    <div class="px-lg-5 mb-4 mb-md-6">

      <div class="row gx-0 gx-md-8 gx-xl-12 gy-8 justify-content-center">

        <!-- Judul Halaman -->
        <div class="col-lg-12 mx-auto text-center">
          <h2 class="fs-12 text-uppercase mb-3 text-gradient gradient-1">
            Tentang <?= $this->website->namaweb() ?>
          </h2>

          <h3 class="display-6 text-center px-xl-10 px-xxl-15 mb-10">
            <?= $site->deskripsi ?>
          </h3>
        </div>

        <!-- LOOPING DATA JENJANG -->
        <?php foreach ($jenjang_pendidikan as $jenjang_pendidikan) { ?>

        <div class="col-md-6">
          <div class="card shadow-sm border-0">
            <div class="card-body p-3">

              <div class="text-center">

                <!-- FOTO -->
                <p>
                  <img 
                    src="<?= base_url('assets/upload/image/'.$jenjang_pendidikan->gambar) ?>"
                    class="img-fluid rounded-circle w-50 gallery-thumb"
                    alt="<?= $jenjang_pendidikan->judul_jenjang_pendidikan ?>"
                  />
                </p>

                <!-- JUDUL -->
                <h4 class="text-uppercase mb-2">
                  <?= $jenjang_pendidikan->judul_jenjang_pendidikan ?>
                </h4>

                <!-- RINGKASAN -->
                <p class="mb-3"><?= $jenjang_pendidikan->ringkasan ?></p>

                <!-- Tombol Detail + Pesan WA -->
                <div class="d-flex justify-content-center align-items-center gap-1 mt-2">

                  <!-- Tombol Detail -->
                  <a 
                    href="<?= base_url('jenjang_pendidikan/read/'.$jenjang_pendidikan->slug_jenjang_pendidikan) ?>"
                    class="btn btn-warning btn-sm"
                  >
                    Detail ...
                  </a>

                  <!-- Tombol Pesan -->
                  <?php if ($jenjang_pendidikan->id_jenjang == 1) { ?>

                    <!-- KB / RA = Pesan 1 -->
                    <a 
                      href="https://wa.me/<?= $wa_number ?>?text=<?= urlencode($wa_msgra) ?>"
                      class="btn btn-success btn-sm"
                      target="_blank"
                    >
                      Pesan 1
                    </a>

                  <?php } elseif ($jenjang_pendidikan->id_jenjang == 3) { ?>

                    <!-- MI = Pesan 2 -->
                    <a 
                      href="https://wa.me/<?= $wa_number ?>?text=<?= urlencode($wa_msgmi) ?>"
                      class="btn btn-primary btn-sm"
                      target="_blank"
                    >
                      Pesan 2
                    </a>

                  <?php } ?>

                </div>
                <!-- /Tombol -->

              </div> <!-- /text-center -->

            </div>
          </div>
        </div>

        <?php } ?> <!-- END FOREACH -->

      </div> <!-- /row -->
    </div>
  </div>
</section>
<?php } ?>
