<style>
/* Gambar kecil kiri */
.berita-image {
    width: 100%;
    height: auto;
    border-radius: 6px;
    cursor: zoom-in;
    transition: .2s;
}

.berita-image:hover {
    opacity: .85;
}

/* Lightbox */
.img-lightbox {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.85);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 99999;
    cursor: zoom-out;
}

.img-lightbox img {
    max-width: 92%;
    max-height: 92%;
    border-radius: 10px;
}

.img-lightbox.show {
    display: flex;
}

.gallery-thumb {
  width: 100% !important;
  height: 220px !important; 
  object-fit: cover !important;
  object-position: center !important;
  display: block !important;
}


</style>

<!-- /header -->
<section class="wrapper image-wrapper bg-image" data-image-src="<?php echo $this->website->banner() ?>" style="min-height:220px;background-size:cover;background-position:center;">
  <!-- banner background only -->
</section>

<section class="wrapper bg-light">
  <div class="container pb-11">

    <!-- DETAIL FASILITAS -->
    <div class="row mb-14 mb-md-16">
      <div class="col-xl-12 mx-auto mt-n19">
        <div class="card">
          <div class="row gx-0">

            <!-- FOTO -->
            <div class="col-lg-4 align-self-stretch">
              <div class="card-body d-flex align-items-center justify-content-center">
                <a href="<?= base_url('assets/upload/image/'.$fasilitas->gambar) ?>" class="img-preview">
                <img src="<?php echo base_url('assets/upload/image/'.$fasilitas->gambar) ?>" class="img img-thumbnail" style="max-width:100%">
</a></div>
            </div>

            <!-- DETAIL -->
            <div class="col-lg-8">
              <div class="card-body">

                <table class="table table-bordered tabelku">
                  <thead>
                    <tr>
                      <th width="25%">Nama Fasilitas</th>
                      <th><?php echo $fasilitas->judul_fasilitas ?></th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td class="bg-light">Kategori</td>
                      <td><?php echo $fasilitas->nama_kategori_fasilitas ?></td>
                    </tr>
                    <tr>
                      <td class="bg-light">Info Lain</td>
                      <td><?php echo $fasilitas->isi ?></td>
                    </tr>
                  </tbody>
                </table>

              </div>
            </div>

          </div>
        </div>
      </div>
    </div>

    <!-- FASILITAS LAIN -->
    <div class="row grid-view gx-md-8 gx-xl-10 gy-8 gy-lg-0 mt-5 justify-content-center">
      <div class="col-xl-12">
        <h3 class="text-center mt-5 mb-5">Lihat Fasilitas Lainnya…</h3>
      </div>

      <?php foreach($fasilitas_list as $fas) { ?>
      <div class="col-md-6 col-lg-3 mb-8">
        <div class="position-relative">
          <div 
            class="shape rounded bg-soft-blue rellax d-md-block" 
            data-rellax-speed="0"
            style="bottom: -0.75rem; right: -0.75rem; width: 98%; height: 98%; z-index:0">
          </div>

          <div class="card">
            <figure class="card-img-top">
              <a href="<?php echo base_url('fasilitas/read/' . $fas['slug_fasilitas']) ?>">
                  <img class="img-fluid gallery-thumb"
                      src="<?php echo base_url('assets/upload/image/' . $fas['gambar']) ?>"
                      alt="<?php echo $fas['judul_fasilitas'] ?>" />
              </a>
          </figure>

          <div class="card-body px-6 py-5">
              <h5 class="mb-1">
                  <a href="<?php echo base_url('fasilitas/read/'.$fas['slug_fasilitas']) ?>">
                      <?php echo $fas['judul_fasilitas'] ?>
                  </a>
              </h5>
          </div>

          </div>

        </div>
      </div>
      <?php } ?>

    </div>

  </div>
</section>
<div id="lightbox" class="img-lightbox" onclick="closeLightbox()">
    <img id="lightbox-img" src="">
</div>
<script>
function closeLightbox() {
    document.getElementById("lightbox").classList.remove("show");
}

document.querySelectorAll('.img-preview').forEach(link => {
    link.addEventListener('click', function(e){
        e.preventDefault();
        document.getElementById("lightbox-img").src = this.href;
        document.getElementById("lightbox").classList.add("show");
    });
});
</script>