<style>
.card-wrapper {
  display: flex !important;
  flex-direction: row !important;
  gap: 15px;
}

.card-wrapper > div:first-child {
  width: 180px;         /* ukuran sisi kiri (gambar) */
  flex-shrink: 0;
}

.news-thumb {
  width: 100%;
  height: 130px;
  object-fit: cover;
  border-radius: 6px;
}

.news-content {
  flex: 1;
}

</style>

<!-- Banner -->
<section class="wrapper image-wrapper bg-image banner-image"
         data-image-src="<?php echo $this->website->banner() ?>">
</section>

<!-- List Berita -->
<section class="wrapper bg-light">

  <!-- news styles moved to assets/css/template.css -->

  <div class="container pb-11">
    <div class="row mb-14 mb-md-16">
      <div class="col-xl-12 mx-auto mt-n19">

  <!-- LOOP LIST BERITA -->
  <!-- Wrapper Card Berita -->
  <div class="card shadow-sm border-0 mb-4">
    <div class="card-body p-4">

      <?php if (empty($berita)) { ?>

        <!-- Jika tidak ada berita -->
        <div class="text-center py-5">
          <h5 class="text-muted">Belum ada berita.</h5>
        </div>

      <?php } else { ?>

        <?php foreach ($berita as $b) { ?>

          <!-- Card Berita -->
          <div class="card mb-4 border-0 news-card">
            <div class="card-body p-3 card-wrapper d-flex align-items-start gap-3">

              <!-- Thumbnail -->
              <?php if ($b->gambar != '') { ?>
                <div class="news-thumb-area">
                  <a href="<?php echo base_url('berita/read/' . $b->slug_berita) ?>">
                    <img class="news-thumb"
                        src="<?php echo base_url('assets/upload/image/' . $b->gambar) ?>"
                        alt="<?php echo esc($b->judul_berita) ?>">
                  </a>
                </div>
              <?php } else { ?>
                <div class="news-thumb-area">
                  <a href="<?php echo base_url('berita/read/' . $b->slug_berita) ?>">
                    <img class="news-thumb"
                        src="<?php echo base_url('assets/upload/image/no-image.png') ?>"
                        alt="no image">
                  </a>
                </div>
              <?php } ?>

              <!-- Isi Konten -->
              <div class="news-content flex-grow-1">
                <h5 class="mb-1">
                  <a href="<?php echo base_url('berita/read/' . $b->slug_berita) ?>"
                    class="link-dark text-decoration-none">
                    <?php echo $b->judul_berita ?>
                  </a>
                </h5>

                <p class="mb-1 small meta">
                  <?php echo $this->website->tanggal_bulan($b->tanggal_publish) ?>
                  &middot; <?php echo $b->nama ?>
                </p>

                <p class="news-summary"><?php echo strip_tags($b->ringkasan) ?></p>

                <div class="mt-2 small text-muted">
                  <i class="fa fa-eye"></i> Dibaca <?php echo $b->hits ?> kali
                </div>
              </div>

            </div>
          </div>
          <!-- /Card Berita -->

        <?php } // end foreach ?>

      <?php } // end else ?>

      <!-- Pagination -->
      <div class="text-center mt-4">
        <?php if (isset($pagination)) { echo str_replace('index.php/', '', $pagination); } ?>
      </div>

    </div>
  </div>

<!-- /Wrapper Card Berita -->

        <!-- END LOOP -->

      </div> <!-- /col-xl-12 -->
    </div> <!-- /row -->
  </div> <!-- /container -->

</section>
