<!-- Combined Logo / Banner / Icon / Login tabs -->
<div>
	<!-- Nav tabs -->
	<ul class="nav nav-tabs" id="konfMediaTabs" role="tablist">
		<li class="nav-item">
			<a class="nav-link active" id="tab-logo-link" data-toggle="tab" href="#tab-logo" role="tab" aria-controls="tab-logo" aria-selected="true">Logo</a>
		</li>
		<li class="nav-item">
			<a class="nav-link" id="tab-banner-link" data-toggle="tab" href="#tab-banner" role="tab" aria-controls="tab-banner" aria-selected="false">Banner</a>
		</li>
		<li class="nav-item">
			<a class="nav-link" id="tab-icon-link" data-toggle="tab" href="#tab-icon" role="tab" aria-controls="tab-icon" aria-selected="false">Icon</a>
		</li>
	</ul>

	<!-- Tab panes -->
	<div class="tab-content p-3 border bg-white" id="konfMediaTabsContent">

		<!-- LOGO -->
		<div class="tab-pane fade show active" id="tab-logo" role="tabpanel" aria-labelledby="tab-logo-link">
			<form action="<?php echo base_url('admin/konfigurasi/logo') ?>" method="post" accept-charset="utf-8" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
				<input type="hidden" name="id_konfigurasi" value="<?php echo $konfigurasi->id_konfigurasi ?>">
				<div class="form-group row">
					<label class="col-3">Ganti Logo</label>
					<div class="col-6">
						<input type="file" name="logo" value="<?php echo $konfigurasi->logo ?>" class="form-control">
						<small class="text-secondary">Format: JPG, PNG, GIF</small>
						<br>
						<button type="submit" class="btn btn-success mt-2"><i class="fa fa-save"></i> Simpan</button>
					</div>
					<div class="col-3">
						<img src="<?php echo $this->website->logo() ?>" class="img img-thumbnail">
					</div>
				</div>
			<?php echo form_close(); ?>
		</div>

		<!-- BANNER -->
		<div class="tab-pane fade" id="tab-banner" role="tabpanel" aria-labelledby="tab-banner-link">
			<form action="<?php echo base_url('admin/konfigurasi/banner') ?>" method="post" accept-charset="utf-8" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
				<input type="hidden" name="id_konfigurasi" value="<?php echo $konfigurasi->id_konfigurasi ?>">
				<div class="form-group row">
					<label class="col-3">Link Video Profil <span class="text-danger">*</span></label>
					<div class="col-9">
						<input type="text" name="link_video" class="form-control" value="<?php echo $konfigurasi->link_video ?>">
					</div>
				</div>

				<div class="form-group row">
					<label class="col-3">Ganti Banner <span class="text-danger">*</span></label>
					<div class="col-6">
						<input type="file" name="banner" value="<?php echo $konfigurasi->banner ?>" class="form-control">
						<small class="text-secondary">Format: JPG, PNG, GIF</small>
					</div>
					<div class="col-3">
						<img src="<?php echo $this->website->banner() ?>" class="img img-thumbnail">
					</div>
				</div>

				<div class="form-group row">
					<label class="col-3"></label>
					<div class="col-9">
						<a href="<?php echo base_url('admin/konfigurasi') ?>" class="btn btn-outline-info">
							<i class="fa fa-arrow-left"></i>
						</a>
						<button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Simpan dan Update</button>
					</div>
				</div>

			<?php echo form_close(); ?>

			<?php echo view('admin/berita/media'); ?>
			<?php echo view('admin/berita/download'); ?>
			<?php echo view('admin/berita/galeri'); ?>
		</div>

		<!-- ICON -->
		<div class="tab-pane fade" id="tab-icon" role="tabpanel" aria-labelledby="tab-icon-link">
			<form action="<?php echo base_url('admin/konfigurasi/icon') ?>" method="post" accept-charset="utf-8" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
				<input type="hidden" name="id_konfigurasi" value="<?php echo $konfigurasi->id_konfigurasi ?>">
				<div class="form-group row">
					<label class="col-3">Ganti Icon</label>
					<div class="col-6">
						<input type="file" name="icon" value="<?php echo $konfigurasi->icon ?>" class="form-control">
						<small class="text-secondary">Format: JPG, PNG, GIF</small>
						<br>
						<button type="submit" class="btn btn-success mt-2"><i class="fa fa-save"></i> Simpan</button>
					</div>
					<div class="col-3">
						<img src="<?php echo $this->website->icon() ?>" class="img img-thumbnail">
					</div>
				</div>
			<?php echo form_close(); ?>
		</div>

	</div>

</div>

<!-- Remember last-open tab (persist across refresh/submit) -->
<script>
	(function(){
		try {
			var storageKey = 'konfigurasi_last_tab';
			// Activate stored tab or hash on load
			document.addEventListener('DOMContentLoaded', function(){
				var last = localStorage.getItem(storageKey);
				var hash = window.location.hash;
				if(hash) {
					var el = document.querySelector('a[href="'+hash+'"]');
					if(el) $(el).tab('show');
				} else if(last) {
					var el2 = document.querySelector('a[href="'+last+'"]');
					if(el2) $(el2).tab('show');
				}
			});

			// Store when tab shown
			$(document).on('shown.bs.tab', 'a[data-toggle="tab"]', function (e) {
				try { localStorage.setItem(storageKey, $(e.target).attr('href')); } catch(e){}
			});
		} catch(e) {
			console && console.warn && console.warn('Tab persistence not available', e);
		}
	})();
</script>