﻿<?php
echo form_open_multipart(base_url('admin/konfigurasi'));
echo csrf_field();
?>
<input type="hidden" name="id_konfigurasi" value="<?= $konfigurasi->id_konfigurasi ?>">

<div class="card card-primary card-outline">
    <div class="card-header p-2">
        <ul class="nav nav-pills" id="configTabs">
            <li class="nav-item"><a class="nav-link active" href="#tab_basic" data-toggle="tab">Informasi Dasar</a></li>
            <li class="nav-item"><a class="nav-link" href="#tab_profile" data-toggle="tab">Profil</a></li>
            <li class="nav-item"><a class="nav-link" href="#tab_kontak" data-toggle="tab">Kontak & Alamat</a></li>
            <li class="nav-item"><a class="nav-link" href="#tab_sosmed" data-toggle="tab">Media Sosial</a></li>
        </ul>
    </div>

    <div class="card-body">
        <div class="tab-content">

            <!-- Informasi Dasar -->
            <div class="tab-pane active" id="tab_basic">
                
                <h4>Informasi Dasar</h4><hr>

                <div class="form-group row">
                    <label class="col-3">Nama Website</label>
                    <div class="col-9">
                        <input type="text" name="namaweb" class="form-control" value="<?= $konfigurasi->namaweb ?>" required>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Singkatan Website</label>
                    <div class="col-9">
                        <input type="text" name="singkatan" class="form-control" value="<?= $konfigurasi->singkatan ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Nama Kepala Sekolah</label>
                    <div class="col-9">
                        <input type="text" name="nama_kepsek" class="form-control" value="<?= isset($konfigurasi->nama_kepsek) ? $konfigurasi->nama_kepsek : '' ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Foto Kepala Sekolah</label>
                    <div class="col-9">

                    <?php if (!empty($konfigurasi) && !empty($konfigurasi->foto_kepsek)) : ?>
                        <div class="mb-2">
                            <img src="<?= base_url('assets/upload/image/' . $konfigurasi->foto_kepsek) ?>"
                                class="img img-thumbnail" style="max-height:150px;">
                        </div>
                    <?php endif; ?>


                        <input type="file" name="foto_kepsek" class="form-control">
                        <small class="text-muted">Format: JPG/PNG. Biarkan kosong jika tidak ingin mengganti.</small>

                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Tagline Website</label>
                    <div class="col-9">
                        <input type="text" name="tagline" class="form-control" value="<?= $konfigurasi->tagline ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Alamat Website</label>
                    <div class="col-6">
                        <input type="text" name="website" class="form-control" value="<?= $konfigurasi->website ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Setting Pagination</label>
                    <div class="col-3">
                        <input type="number" name="paginasi" class="form-control" value="<?= $konfigurasi->paginasi ?>">
                        <small>Paginasi backend</small>
                    </div>
                    <div class="col-3">
                        <input type="number" name="paginasi_depan" class="form-control" value="<?= $konfigurasi->paginasi_depan ?>">
                        <small>Paginasi frontend</small>
                    </div>
                </div>

            </div>


            <!-- Profil -->
            <div class="tab-pane" id="tab_profile">

                <h4>Profil Website</h4><hr>

                <div class="form-group row">
                    <label class="col-3">Tentang Website</label>
                    <div class="col-9">
                        <textarea name="tentang" class="form-control konten" rows="20"><?= $konfigurasi->tentang ?></textarea>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Deskripsi Ringkas</label>
                    <div class="col-9">
                        <textarea name="deskripsi" class="form-control" rows="3"><?= $konfigurasi->deskripsi ?></textarea>
                    </div>
                </div>

            </div>


            <!-- Kontak -->
            <div class="tab-pane" id="tab_kontak">

                <h4>Kontak & Alamat</h4><hr>

                <div class="form-group row">
                    <label class="col-3">Official Email</label>
                    <div class="col-6">
                        <input type="text" name="email" class="form-control" value="<?= $konfigurasi->email ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Secondary Email</label>
                    <div class="col-6">
                        <input type="text" name="email_cadangan" class="form-control" value="<?= $konfigurasi->email_cadangan ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Telepon</label>
                    <div class="col-6">
                        <input type="text" name="telepon" class="form-control" value="<?= $konfigurasi->telepon ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">HP</label>
                    <div class="col-6">
                        <input type="text" name="hp" class="form-control" value="<?= $konfigurasi->hp ?>">
                    </div>
                </div>

				<div class="form-group row">
                    <label class="col-3">Nomor Whatsapp</label>
                    <div class="col-6">
                        <input type="text" name="whatsapp" class="form-control" value="<?= $konfigurasi->whatsapp ?>">
                        <small class="text-warning">Format: 628xxxx</small>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Pesan Whatsapp</label>
                    <div class="col-9">
                        <textarea name="pesan_whatsapp" class="form-control"><?= $konfigurasi->pesan_whatsapp ?></textarea>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Whatsapp KB/RA</label>
                    <div class="col-9">
                        <textarea name="pesan_midaftar" class="form-control"><?= $konfigurasi->pesan_midaftar ?></textarea>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label class="col-3">Whatsapp MI</label>
                    <div class="col-9">
                        <textarea name="pesan_kbradaftar" class="form-control"><?= $konfigurasi->pesan_kbradaftar ?></textarea>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Alamat</label>
                    <div class="col-9">
                        <textarea name="alamat" class="form-control summernote"><?= $konfigurasi->alamat ?></textarea>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-3">Google Map</label>
                    <div class="col-9">
                        <textarea name="google_map" class="form-control"><?= $konfigurasi->google_map ?></textarea>
                    </div>
                </div>

            </div>

            <!-- Media Sosial -->
            <div class="tab-pane" id="tab_sosmed">

                <h4>Media Sosial</h4><hr>

                <?php
				$socials = [
					'facebook' => 'Facebook',
					'instagram' => 'Instagram',
					'youtube' => 'Youtube'
				];
				foreach ($socials as $key => $label):
					?>

                <div class="form-group row">
                    <label class="col-3"><?= $label ?></label>
                    <div class="col-3">
                        <input type="text" name="nama_<?= $key ?>" class="form-control" value="<?= $konfigurasi->{'nama_' . $key} ?>">
                        <small>Nama akun</small>
                    </div>
                    <div class="col-6">
                        <input type="text" name="<?= $key ?>" class="form-control" value="<?= $konfigurasi->$key ?>">
                        <small>Link akun</small>
                    </div>
                </div>

                <?php endforeach; ?>

            </div>

        </div>
    </div>

    <!-- Simpan -->
    <div class="card-footer bg-white" style="position: sticky; bottom: 0; z-index: 10; border-top: 1px solid #ddd;">
        <button type="submit" class="btn btn-success">
            <i class="fa fa-save"></i> Simpan
        </button>
    </div>

</div>

<?php echo form_close(); ?>
