<?php namespace App\Models;

use CodeIgniter\Model;

class Fasilitas_model extends Model
{
    protected $table = 'fasilitas';
    protected $primaryKey = 'id_fasilitas';
    protected $allowedFields = [];

    // Listing
    public function listing()
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->get()->getResult();
    }

    // Read detail by slug
    public function read($slug_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->where('fasilitas.slug_fasilitas',$slug_fasilitas)
            ->get()->getRow();
    }

    // Home block
    public function home($limit,$status_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->where('fasilitas.status_fasilitas',$status_fasilitas)
            ->limit((int)$limit)
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->get()->getResult();
    }

    public function status_fasilitas($limit,$start,$status_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, fasilitas.slug_fasilitas, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->where('fasilitas.status_fasilitas',$status_fasilitas)
            ->limit($limit,$start)
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->get()->getResult();
    }

    public function total_status_fasilitas($status_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->where('status_fasilitas',$status_fasilitas)
            ->countAllResults();
    }

    public function kategori_fasilitas($limit, $start, $slug_kategori_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->where('kategori_fasilitas.slug_kategori_fasilitas',$slug_kategori_fasilitas)
            ->limit($limit,$start)
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->get()->getResult();
    }

    public function kategori_fasilitas_status($limit, $start, $id_kategori_fasilitas,$status_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->where([
                'fasilitas.id_kategori_fasilitas' => $id_kategori_fasilitas,
                'fasilitas.status_fasilitas'      => $status_fasilitas
            ])
            ->limit($limit,$start)
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->get()->getResult();
    }

    public function total_kategori_fasilitas_status($id_kategori_fasilitas,$status_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->where('id_kategori_fasilitas',$id_kategori_fasilitas)
            ->where('status_fasilitas',$status_fasilitas)
            ->countAllResults();
    }

    // Paginasi admin
    public function paginasi_admin($limit,$start)
    {
        return $this->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->limit((int)$limit,(int)$start)
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->findAll();
    }

    public function paginasi_admin_cari($keywords,$limit,$start)
    {
        return $this->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->groupStart()
                ->like('fasilitas.judul_fasilitas',$keywords)
                ->orLike('fasilitas.website',$keywords)
                ->orLike('fasilitas.isi',$keywords)
            ->groupEnd()
            ->limit($limit,$start)
            ->orderBy('fasilitas.id_fasilitas','DESC')
            ->findAll();
    }

    public function total_cari($keywords)
    {
        return $this->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->groupStart()
                ->like('fasilitas.judul_fasilitas',$keywords)
                ->orLike('fasilitas.website',$keywords)
                ->orLike('fasilitas.isi',$keywords)
            ->groupEnd()
            ->countAllResults();
    }

    public function total()
    {
        return $this->countAll();
    }

    public function total_kategori_fasilitas($id_kategori_fasilitas)
    {
        return $this->where('id_kategori_fasilitas',$id_kategori_fasilitas)->countAllResults();
    }

    public function detail($id_fasilitas)
    {
        return $this->db->table('fasilitas')
            ->select('fasilitas.*, kategori_fasilitas.nama_kategori_fasilitas, kategori_fasilitas.slug_kategori_fasilitas, users.nama')
            ->join('kategori_fasilitas','kategori_fasilitas.id_kategori_fasilitas = fasilitas.id_kategori_fasilitas','LEFT')
            ->join('users','users.id_user = fasilitas.id_user','LEFT')
            ->where('fasilitas.id_fasilitas',$id_fasilitas)
            ->get()->getRow();
    }

    public function tambah($data)
    {
        return $this->db->table('fasilitas')->insert($data);
    }

    public function edit($data)
    {
        return $this->db->table('fasilitas')
            ->where('id_fasilitas',$data['id_fasilitas'])
            ->update($data);
    }

    public function slider()
    {
        return $this->where('jenis_fasilitas','Homepage')
            ->orderBy('id_fasilitas','DESC')
            ->first();
    }

    public function jenis_fasilitas($jenis_fasilitas)
    {
        return $this->where('jenis_fasilitas',$jenis_fasilitas)
            ->orderBy('id_fasilitas','DESC')
            ->findAll(5);
    }

    public function jenis_fasilitas_1($jenis_fasilitas)
    {
        return $this->where('jenis_fasilitas',$jenis_fasilitas)
            ->orderBy('id_fasilitas','DESC')
            ->first();
    }

    public function fasilitas()
    {
        return $this->where('jenis_fasilitas','Fasilitas')
            ->orderBy('id_fasilitas','DESC')
            ->findAll();
    }

    public function related($id_kategori_fasilitas, $id_fasilitas, $limit = 10)
    {
        return $this->where('id_kategori_fasilitas', $id_kategori_fasilitas)
            ->where('id_fasilitas !=', $id_fasilitas)
            ->where('status_fasilitas', 'Publish')
            ->orderBy('id_fasilitas', 'DESC')
            ->findAll($limit);
    }

    public function updateHits($id)
    {
        return $this->db->table($this->table)
            ->set('hits', 'hits + 1', false)
            ->where('id_fasilitas', $id)
            ->update();
    }
}
