<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddNamaKepsekToKonfigurasi extends Migration
{
    public function up()
    {
        $forge = \Config\Database::forge();
        // Add column if not exists
        $fields = [
            'nama_kepsek' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'default' => null,
                'after' => 'website'
            ]
        ];
        // Try to add column only if it doesn't exist
        $db = \Config\Database::connect();
        $schema = $db->getFieldData('konfigurasi');
        $cols = array_map(function($f){ return $f->name; }, $schema);
        if (!in_array('nama_kepsek', $cols)) {
            $forge->addColumn('konfigurasi', $fields);
        }
    }

    public function down()
    {
        $forge = \Config\Database::forge();
        $db = \Config\Database::connect();
        $schema = $db->getFieldData('konfigurasi');
        $cols = array_map(function($f){ return $f->name; }, $schema);
        if (in_array('nama_kepsek', $cols)) {
            $forge->dropColumn('konfigurasi', 'nama_kepsek');
        }
    }
}
