<?php 
namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\Fasilitas_model;
use App\Models\Kategori_fasilitas_model;

class Fasilitas extends BaseController
{

	// INDEX
	public function index()
	{
		$m_fasilitas 			= new Fasilitas_model();
		$m_kategori_fasilitas 	= new Kategori_fasilitas_model();
		$kategori_fasilitas 	= $m_kategori_fasilitas->listing();
		$pager 					= service('pager');

		// Jika ada pencarian
		if ($this->request->getGet('keywords')) {
			$keywords 	= $this->request->getVar('keywords');
			$total 		= $m_fasilitas->total_cari($keywords);
			$title 		= 'Hasil pencarian: '.$keywords.' ('.$total.' ditemukan)';

	        $page    	= (int) ($this->request->getGet('page') ?? 1);
	        $perPage 	= $this->website->paginasi();
	        $pager_links= $pager->makeLinks($page, $perPage, $total,'bootstrap_pagination');
	        $offset 	= ($page - 1) * $perPage;

	        $fasilitas 	= $m_fasilitas->paginasi_admin_cari($keywords, $perPage, $offset);

		} else {

			$total 		= $m_fasilitas->total();
			$title 		= 'Fasilitas ('.$total.')';

	        $page    	= (int) ($this->request->getGet('page') ?? 1);
	        $perPage 	= $this->website->paginasi();
	        $pager_links= $pager->makeLinks($page, $perPage, $total,'bootstrap_pagination');
	        $offset 	= ($page - 1) * $perPage;

	        $fasilitas 	= $m_fasilitas->paginasi_admin($perPage, $offset);
		}

		$data = [
			'title'					=> $title,
			'fasilitas'				=> $fasilitas,
			'kategori_fasilitas'	=> $kategori_fasilitas,
			'pagination'			=> $pager_links,
			'content'				=> 'admin/fasilitas/index'
		];

		return view('admin/layout/wrapper',$data);
	}

	// TAMBAH
	public function tambah()
	{
		$m_fasilitas 			= new Fasilitas_model();
		$m_kategori_fasilitas 	= new Kategori_fasilitas_model();
		$kategori_fasilitas 	= $m_kategori_fasilitas->listing();

		if ($this->request->getMethod() === 'POST' && $this->validate([
			'judul_fasilitas' 	=> 'required|is_unique[fasilitas.judul_fasilitas]',
			'gambar'	 		=> 'ext_in[gambar,jpg,jpeg,gif,png,svg]|max_size[gambar,4096]'
		])) {

			$gambar = $this->request->getFile('gambar');
			$namabaru = '';

			if ($gambar && $gambar->isValid() && !$gambar->hasMoved()) {
				$namabaru = $gambar->getRandomName();
				$gambar->move(FCPATH . 'assets/upload/image/', $namabaru);

				// Thumb
				\Config\Services::image()
				    ->withFile(FCPATH . 'assets/upload/image/'.$namabaru)
				    ->fit(100, 100, 'center')
				    ->save(FCPATH . 'assets/upload/image/thumbs/'.$namabaru);
			}

			$data = [
        		'id_user'					=> $this->session->get('id_user'),
				'id_kategori_fasilitas'		=> $this->request->getVar('id_kategori_fasilitas'),
				'slug_fasilitas'			=> strtolower(url_title($this->request->getVar('judul_fasilitas'))),
				'judul_fasilitas'			=> $this->request->getVar('judul_fasilitas'),
				'kode_nomor_fasilitas'		=> $this->request->getVar('kode_nomor_fasilitas'),
				'isi'						=> $this->request->getVar('isi'),
				'gambar' 					=> $namabaru,
				'status_text'				=> $this->request->getVar('status_text'),
				'status_fasilitas'			=> $this->request->getVar('status_fasilitas'),
				'tanggal_post'				=> date('Y-m-d H:i:s')
        	];

        	$m_fasilitas->tambah($data);
       		return redirect()->to(base_url('admin/fasilitas'))->with('sukses', 'Data telah disimpan');
		}

		$data = [
			'title'					=> 'Tambah Fasilitas',
			'kategori_fasilitas'	=> $kategori_fasilitas,
			'content'				=> 'admin/fasilitas/tambah'
		];

		return view('admin/layout/wrapper',$data);
	}

	// PROSES
	public function proses()
	{
		$m_fasilitas 	= new Fasilitas_model();

		$pengalihan 	= $this->request->getVar('pengalihan');
		$submit 		= $this->request->getVar('submit');
		$id_fasilitas 	= $this->request->getVar('id_fasilitas');

		if (!$id_fasilitas) {
			return redirect()->to($pengalihan)->with('warning', 'Anda belum memilih data.');
		}

		foreach ($id_fasilitas as $idf) {
			$data = [
				'id_fasilitas' => $idf,
				'id_user'		=> $this->session->get('id_user'),
			];

			if ($submit == 'Update') {
				$data['id_kategori_fasilitas'] = $this->request->getVar('id_kategori_fasilitas');
			}

			if ($submit == 'Publish') {
				$data['status_fasilitas'] = 'Publish';
			}

			if ($submit == 'Draft') {
				$data['status_fasilitas'] = 'Draft';
			}

			if ($submit == 'Delete') {
				$m_fasilitas->delete(['id_fasilitas' => $idf]);
				continue;
			}

			$m_fasilitas->edit($data);
		}

		return redirect()->to($pengalihan)->with('sukses', 'Proses berhasil.');
	}

	// EDIT
	public function edit($id_fasilitas)
	{
		$m_kategori 		= new Kategori_fasilitas_model();
		$m_fasilitas 		= new Fasilitas_model();

		$kategori_fasilitas = $m_kategori->listing();
		$fasilitas 			= $m_fasilitas->detail($id_fasilitas);

		if ($this->request->getMethod() === 'POST' && $this->validate([
			'judul_fasilitas' => 'required',
			'gambar'	 	  => 'ext_in[gambar,jpg,jpeg,gif,png,svg]|max_size[gambar,10240]'
		])) {

			$gambar = $this->request->getFile('gambar');
			$namabaru = $fasilitas->gambar;

			if ($gambar && $gambar->isValid() && !$gambar->hasMoved()) {
				$namabaru = $gambar->getRandomName();
				$gambar->move(FCPATH . 'assets/upload/image/', $namabaru);

				\Config\Services::image()
				    ->withFile(FCPATH . 'assets/upload/image/'.$namabaru)
				    ->fit(100, 100, 'center')
				    ->save(FCPATH . 'assets/upload/image/thumbs/'.$namabaru);
			}

			$data = [
        		'id_fasilitas'			=> $id_fasilitas,
        		'id_user'				=> $this->session->get('id_user'),
				'id_kategori_fasilitas'	=> $this->request->getVar('id_kategori_fasilitas'),
				'slug_fasilitas'		=> strtolower(url_title($this->request->getVar('judul_fasilitas'))),
				'judul_fasilitas'		=> $this->request->getVar('judul_fasilitas'),
				'kode_nomor_fasilitas'	=> $this->request->getVar('kode_nomor_fasilitas'),
				'isi'					=> $this->request->getVar('isi'),
				'gambar' 				=> $namabaru,
				'status_text'			=> $this->request->getVar('status_text'),
				'status_fasilitas'		=> $this->request->getVar('status_fasilitas'),
        	];

        	$m_fasilitas->edit($data);
       		return redirect()->to(base_url('admin/fasilitas'))->with('sukses', 'Data telah diperbarui');
		}

		$data = [
			'title'					=> 'Edit Fasilitas',
			'kategori_fasilitas'	=> $kategori_fasilitas,
			'fasilitas'				=> $fasilitas,
			'content'				=> 'admin/fasilitas/edit'
		];

		return view('admin/layout/wrapper',$data);
	}

	// DELETE
	public function delete($id_fasilitas)
	{
		$m_fasilitas = new Fasilitas_model();
		$m_fasilitas->delete(['id_fasilitas' => $id_fasilitas]);

		return redirect()->to(base_url('admin/fasilitas'))->with('sukses','Data telah dihapus');
	}

}
